<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-sRIl4kxILFvY47J16cr9ZwB07vP4J8+LH7qKQnuqkuIAvNWLzeN8tE5YBujZqJLB" crossorigin="anonymous">
    <title>Document</title>
</head>

<body>

    {{-- <button id="start">Start</button> --}}
    <button style="display: none" id="stop" disabled>Pause</button>
    <audio style="display: none" id="audio" controls></audio>
    <audio style="display: none" controls src="" id="answer"></audio>


    <div class="w-100 h-100 d-flex justify-content-center align-items-center">
        <button id="start">Start</button>
    </div>






    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        // let recorder;
        // let audioChunks = [];
        let recorder;
        let audioChunks = [];
        let silenceTimer;
        let analyser;
        let audioContext;
        let source;


        $("#start").click(async () => {
            const stream = await navigator.mediaDevices.getUserMedia({
                audio: true
            });
            recorder = new MediaRecorder(stream);
            audioChunks = [];
            recorder.start();

            recorder.ondataavailable = e => audioChunks.push(e.data);
            //$("#start").attr('disabled', true);
            //$("#stop").attr('disabled', false);
            $("#start").css('background-color', 'blue');
            $("#start").text('pause');

            // ایجاد AudioContext برای بررسی صدا
            audioContext = new AudioContext();
            source = audioContext.createMediaStreamSource(stream);
            analyser = audioContext.createAnalyser();
            source.connect(analyser);

            detectSilence();
        });

        function detectSilence() {
            const data = new Uint8Array(analyser.fftSize);
            analyser.getByteTimeDomainData(data);

            // محاسبه RMS برای تشخیص صدا
            let rms = 0;
            for (let i = 0; i < data.length; i++) {
                let val = (data[i] - 128) / 128;
                rms += val * val;
            }
            rms = Math.sqrt(rms / data.length);

            if (rms < 0.01) { // اگر صدا خیلی کم بود
                if (!silenceTimer) {
                    silenceTimer = setTimeout(() => {
                        $("#stop").click(); // خودکار stop
                    }, 2000); // 2 ثانیه سکوت
                }
            } else {
                clearTimeout(silenceTimer);
                silenceTimer = null;
            }

            requestAnimationFrame(detectSilence);
        }

        $("#stop").click(async () => {
            // $("#start").attr('disabled', false);
            // $("#stop").attr('disabled', true);

            $("#start").css('background-color', 'green');
            $("#start").text('Waiting...');
            $("#start").prop("disabled", true);

            recorder.stop();

            recorder.onstop = async () => {
                const blob = new Blob(audioChunks);
                const arrayBuffer = await blob.arrayBuffer();

                const audioContext = new AudioContext();
                const audioBuffer = await audioContext.decodeAudioData(arrayBuffer);

                const wavBlob = audioBufferToWav(audioBuffer);
                const wavUrl = URL.createObjectURL(wavBlob);

                $("#audio").attr("src", wavUrl);

                sendWavToServer(wavBlob);
            };
        });

        // تبدیل AudioBuffer به WAV
        function audioBufferToWav(buffer) {
            const numChannels = buffer.numberOfChannels;
            const sampleRate = buffer.sampleRate;
            const length = buffer.length * numChannels * 2;
            const bufferArray = new ArrayBuffer(44 + length);
            const view = new DataView(bufferArray);

            writeString(view, 0, 'RIFF');
            view.setUint32(4, 36 + length, true);
            writeString(view, 8, 'WAVE');
            writeString(view, 12, 'fmt ');
            view.setUint32(16, 16, true);
            view.setUint16(20, 1, true);
            view.setUint16(22, numChannels, true);
            view.setUint32(24, sampleRate, true);
            view.setUint32(28, sampleRate * numChannels * 2, true);
            view.setUint16(32, numChannels * 2, true);
            view.setUint16(34, 16, true);
            writeString(view, 36, 'data');
            view.setUint32(40, length, true);

            let offset = 44;
            for (let i = 0; i < buffer.length; i++) {
                for (let ch = 0; ch < numChannels; ch++) {
                    let sample = buffer.getChannelData(ch)[i];
                    sample = Math.max(-1, Math.min(1, sample));
                    view.setInt16(offset, sample * 0x7fff, true);
                    offset += 2;
                }
            }

            return new Blob([view], {
                type: 'audio/wav'
            });
        }

        function writeString(view, offset, string) {
            for (let i = 0; i < string.length; i++) {
                view.setUint8(offset + i, string.charCodeAt(i));
            }
        }

        function sendWavToServer(wavBlob) {
            const formData = new FormData();
            formData.append("voice", wavBlob, "voice.wav");

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "/voice/send",
                type: "POST",
                data: formData,
                processData: false, // مهم
                contentType: false, // مهم
                success: function(res) {
                    console.log("ارسال شد", res);
                    $("#answer").attr('src', res.file);
                    $("#answer")[0].play();
                    $("#start").css('background-color', 'gray');
                    $("#start").text('Start');
                    $("#start").prop("disabled", false);

                    
                },
                error: function(err) {
                    console.error("خطا در ارسال", err);
                }
            });
        }
    </script>


</body>

</html>
