<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use OpenAI\Laravel\Facades\OpenAI;



class VoiceController extends Controller
{
    public function index()
    {
        return view('voice.index');

    }


    public function send(Request $request)
{
    //return $this->answer('hello how are you?');
    //return $this->texttovoice('hello my friends my name is arsalan i love you');
    // 1️⃣ گرفتن فایل
    if (!$request->hasFile('voice')) {
        return response()->json(['error' => 'No voice file'], 400);
    }

    $file = $request->file('voice');

    $audioContent = file_get_contents($file->getRealPath());

    // 4️⃣ ارسال به Deepgram
    $response = Http::withHeaders([
        'Authorization' => 'Token ' . '0a06279422da196ebdbdf99eb64073d72c80bc2c',
        'Content-Type'  => 'audio/wav',
    ])->withBody($audioContent, 'audio/wav')
      ->post('https://api.deepgram.com/v1/listen?language=en');
    
    //dd($response->json());
    $text = data_get(
        $response->json(),
        'results.channels.0.alternatives.0.transcript'
    );
    
    // فقط کاراکترهای ASCII نگه دار
    $text = $text ? preg_replace('/[^\x20-\x7E]/', '', $text) : null;


   //return $this->texttovoice($text);

   return $this->answer($text);
    // return response()->json([
    //     'text' => $text
    // ]);
}


public function answer($request)
{
    $system_prompt = 'یک سری سوال ازت میکنم لطفا بهم پاسخ مناسب بده٬سوال ها به انگلیسی هست و تو هم انگلیسی پاسخ بده ٬ سوال ها در حد  یک حال و احوال کردن ساده هست و اینکه پاسخ های کوتاه بده و جواب های قبلی رو هم یادت باشه و اینکه سوال های قبلی من هم بادت باشه';
    $response = OpenAI::responses()->create([
        'model' => 'gpt-5-nano',
        'instructions' => $system_prompt, // سیستم‌پرامپت درست اینجاست
        'input' => [
            [
                "role" => "user",
                "content" => $request  // مستقیم رشته درخواست کاربر
            ]
        ],
    ]);

    //return $response->outputText;
    return $this->texttovoice($response->outputText);
}


public function texttovoice($request)
{
    //$text = $request->input('text');
    $text = $request;

        $apiKey = "sk_ae95981544e456af4a240bc68ddfcea71746ab57cfdfab93";
        $voiceId = 'YXpFCvM1S3JbWEJhoskW';

        $response = Http::withHeaders([
            'xi-api-key' => $apiKey,
            'Content-Type' => 'application/json',
        ])->post("https://api.elevenlabs.io/v1/text-to-speech/$voiceId", [
            'text' => $text,
            'voice_settings' => [
                'stability' => 0.5,
                'similarity_boost' => 0.75
            ]
        ]);

        //dd($response);

        if ($response->successful()) {
            // ذخیره فایل mp3
            // $fileName = 'speech_' . time() . '.mp3';
            // Storage::put('public/' . $fileName, $response->body());

            $fileName = 'speech_' . time() . '.mp3';
            $filePath = public_path('voices/'.$fileName);
            file_put_contents($filePath, $response->body());

            return response()->json([
                'message' => 'فایل صوتی ایجاد شد!',
                'file' => asset('voices/'.$fileName),
            ]);
        }

        return response()->json([
            'message' => 'خطا در تولید صدا',
            'error' => $response->body(),
        ], 500);
}

}
